<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../classi/PannelloLaterale.php";
    include "../template/stile.php";
    include "../gUtil/GestoreTabella.php";
    include "../gUtil/GestoreTraduzioni.php";
    include "../classi/Tabella.php";
    include "../localizzazione/stringheDaTradurre.php";
    
    include "include/controlloLogin.php";
    // gli utenti di tipo autore non possono accedere a questa pagina
    if($_SESSION["geecomAdmin_ruolo"]=="autore") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    $impostazioni        = recuperaImpostazioni($geecomDb);
    $impostazioniLingue  = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    $impostazioniApp     = $geecomDb->leggiSingolaRiga("geec_impostazioniApp",1);
    $statisticheGeecom   = $geecomDb->leggiSingolaRiga("geecB_statistiche",1);
    $impostazioniMotoreRicerca = $geecomDb->leggiSingolaRiga("geecB_impostazioniRicerca",1);
    
    $inclusioni   = $geecomDb->leggiSingolaRiga("geecB_inclusioni",1);
    $configurazioneColore  = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataCms");
    $status       = isset($_GET["status"]) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;
    
    if(isset($_GET["cerca"])) {
        $status = 273;
    }
    
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom CMS - impostazioni</title>
    </head>
    <body>
      
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
        
    <main role="main" class="bg-light" id="main">
        <div class="page-builder container-fluid">
            <div class="row py-4">
                <div class="col-12">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni generali aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==210) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Profili social aggiornati
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==230) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Componente salvato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==231) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Componente salvato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==240) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni footer aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==250) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Inclusioni aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==260) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni cookie aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==270) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni SEO aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==271) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni API aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==272) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni App aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==274) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Mappe del sito aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==275) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni prestazioni aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==280) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni sicurezza aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==285) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Template email aggiornato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==286) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Nuovo template email creato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==290) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni prodotti aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==295) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni ricerca aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==310) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Colori configurazione aggiornati
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==311) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Configurazione clonata
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==312) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Aspetto aggiornato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==320) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Font configurazione aggiornati
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==325) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni multicolonna aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==330) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni barra menu aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==340) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni barra superiore aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==350) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Dimensioni logo aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==500) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni lingue aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==510) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Traduzioni aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                    ?>
                </div>

                <div class="col-2 col-sm-4 col-lg-3 col-xl-2 pr-0 align-self-start sticky-top">
                    <ul class="nav nav-tabs nav-tabs--vertical nav-tabs--left">
                        <li class="nav-item">
                            <a href="#impostazioniGenerali" class="nav-link <?php echo(($status==200 || $status==0) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="impostazioni generali"><i class="fas fa-sliders-h d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Impostazioni generali</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#aspetto" class="nav-link <?php echo(($status==300 || $status==310 || $status==311 || $status==312 || $status==320 || $status==325 || $status==330 || $status==350) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="aspetto"><i class="fas fa-palette d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Aspetto</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#lingue" class="nav-link <?php echo(($status==500) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="lingue"><i class="fas fa-flag d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Lingue</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#traduzioni" class="nav-link <?php echo(($status==510) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="traduzioni"><i class="fas fa-language d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Traduzioni</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#barraSuperiore" class="nav-link <?php echo(($status==340) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="aspetto"><i class="fas fa-arrow-up d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Barra superiore</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#colonnaLateraleSx" class="nav-link <?php echo(($status==230) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="footer"><i class="far fa-window-maximize fa-rotate-270 d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Colonna laterale sinistra</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#colonnaLateraleDx" class="nav-link <?php echo(($status==231) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="footer"><i class="far fa-window-maximize fa-rotate-90 d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Colonna laterale destra</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#footer" class="nav-link <?php echo(($status==240) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="footer"><i class="fas fa-arrow-down d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Footer</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#profiliSocial" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="includi codice"><i class="fas fa-share-alt d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Profili social</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#includiCodice" class="nav-link <?php echo(($status==250) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="includi codice"><i class="fas fa-code d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Includi codice</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#leggeSuiCookies" class="nav-link <?php echo(($status==260) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="legge sui cookies"><i class="fas fa-cookie d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Legge sui cookie</span></a> 
                        </li>
                        <li class="nav-item">
                            <a href="#motoreDiRicerca" class="nav-link <?php echo(($status==295) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="seo"><i class="fas fa-search d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Motore di ricerca</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#seo" class="nav-link <?php echo(($status==270 || $status==274) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="seo"><i class="fas fa-bullseye d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">SEO</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#prestazioni" class="nav-link <?php echo(($status==275) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="seo"><i class="fas fa-rocket d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Prestazioni</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#app" class="nav-link <?php echo(($status==272) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="seo"><i class="fas fa-mobile-alt d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">App</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#api" class="nav-link <?php echo(($status==271 || $status==273) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="api"><i class="fas fa-code-branch d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">API</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#templateEmail" class="nav-link <?php echo(($status==285 || $status==286) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="sicurezza"><i class="fas fa-envelope-open-text d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Template email</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#sicurezza" class="nav-link <?php echo(($status==280) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="sicurezza"><i class="fas fa-shield-alt d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Sicurezza</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#prodotti-installati" class="nav-link <?php echo(($status==290) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti-installati"><i class="fas fa-puzzle-piece d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Prodotti installati</span></a>
                        </li>
                    </ul>
                </div>
                <div class="col-10 col-sm-8 col-lg-9 col-xl-10">
                    <div class="tab-content">

                        <div class="tab-pane fade show <?php echo(($status==200 || $status==0) ? "active" : "")  ?>" id="impostazioniGenerali" role="tabpanel">
                            <?php 
                                include "include/impostazioni/impostazioniGenerali.php";
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show  <?php echo(($status==300 || $status==310 || $status==311 || $status==312 || $status==320 || $status==325 || $status==330 || $status==350) ? "active" : "")  ?>" id="aspetto" role="tabpanel">
                            <?php 
                                include "include/impostazioni/aspetto.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show  <?php echo(($status==500) ? "active" : "")  ?>" id="lingue" role="tabpanel">
                            <?php 
                                include "include/impostazioni/lingue.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show  <?php echo(($status==510) ? "active" : "")  ?>" id="traduzioni" role="tabpanel">
                            <?php 
                                include "include/impostazioni/traduzioni.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==340) ? "active" : "")  ?>" id="barraSuperiore" role="tabpanel">
                            <?php 
                                include "include/impostazioni/barraSuperiore.php";
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==230) ? "active" : "")  ?>" id="colonnaLateraleSx">
                            <?php 
                                include "include/impostazioni/colonnaLateraleSinistra.php";
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==231) ? "active" : "")  ?>" id="colonnaLateraleDx">
                            <?php 
                                include "include/impostazioni/colonnaLateraleDestra.php";
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==240) ? "active" : "")  ?>" id="footer" role="tabpanel">
                            <?php 
                                include "include/impostazioni/footer.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="profiliSocial" role="tabpanel">
                            <?php 
                                include "include/impostazioni/profiliSocial.php"; 
                            ?>
                        </div>

                        <div class="tab-pane fade show <?php echo(($status==250) ? "active" : "")  ?>" id="includiCodice" role="tabpanel">
                            <?php 
                                include "include/impostazioni/inclusioni.php"; 
                            ?>
                        </div>

                        <div class="tab-pane fade show <?php echo(($status==260) ? "active" : "")  ?>" id="leggeSuiCookies" role="tabpanel">
                            <?php 
                                include "include/impostazioni/leggeCookie.php"; 
                            ?>
                        </div>

                        <div class="tab-pane fade show <?= ($status==295) ? "active" : ""  ?>" id="motoreDiRicerca" role="tabpanel">
                            <?php
                                include "include/impostazioni/motoreDiRicerca.php"; 
                            ?>
                        </div>

                        <div class="tab-pane fade show <?php echo(($status==270 || $status==274) ? "active" : "")  ?>" id="seo" role="tabpanel">
                            <?php 
                                include "include/impostazioni/seo.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==275) ? "active" : "")  ?>" id="prestazioni" role="tabpanel">
                            <?php 
                                include "include/impostazioni/prestazioni.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==272) ? "active" : "")  ?>" id="app" role="tabpanel">
                            <?php 
                                include "include/impostazioni/app.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==271 || $status==273) ? "active" : "")  ?>" id="api" role="tabpanel">
                            <?php 
                                include "include/impostazioni/api.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==285 || $status==286) ? "active" : "")  ?>" id="templateEmail" role="tabpanel">
                            <?php 
                                include "include/impostazioni/templateEmail.php"; 
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==280) ? "active" : "")  ?>" id="sicurezza" role="tabpanel">
                            <?php 
                                include "include/impostazioni/sicurezza.php"; 
                            ?>
                        </div>

                        <div class="tab-pane fade show <?php echo(($status==290) ? "active" : "")  ?>" id="prodotti-installati" role="tabpanel">
                            <?php 
                                include "include/impostazioni/prodottiInstallati.php"; 
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/operazioneCompletata.php";
        
        include "include/modalModificheComponentiPannelliLaterali.php";
    ?>
	  
	 <!-- MODALS -->
	  
        <!-- Aggiungi componenti footer superiore -->
            <div class="modal fade" id="aggiungi-componenti" tabindex="-1" role="dialog" aria-labelledby="aggiungi-componenti" aria-hidden="true">
              <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">Aggiungi un componente al footer</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                              <span aria-hidden="true">&times;</span>
                            </button>
                      </div>
                      <div class="modal-body">
                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                              <li class="nav-item">
                                    <a class="nav-link active" id="..." data-toggle="pill" href="#aggiungi-comp-footer-niente" role="tab" aria-controls="niente" aria-selected="true">Niente</a>
                              </li>
                              <li class="nav-item">
                                    <a class="nav-link" id="..." data-toggle="pill" href="#aggiungi-comp-footer-menu" role="tab" aria-controls="menu" aria-selected="false">Menu</a>
                              </li>
                              <li class="nav-item">
                                    <a class="nav-link" id="..." data-toggle="pill" href="#aggiungi-comp-footer-testo" role="tab" aria-controls="testo" aria-selected="false">Testo</a>
                              </li>
                              <li class="nav-item">
                                    <a class="nav-link" id="..." data-toggle="pill" href="#aggiungi-comp-footer-social" role="tab" aria-controls="social" aria-selected="false">Social</a>
                              </li>
                              <li class="nav-item">
                                    <a class="nav-link" id="..." data-toggle="pill" href="#aggiungi-comp-footer-lingue" role="tab" aria-controls="switch-lingue" aria-selected="false">Switch lingue</a>
                              </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                              <div class="tab-pane fade show active" id="aggiungi-comp-footer-niente" role="tabpanel" aria-labelledby="...">
                                    <p>Non verrà aggiunto alcun componente alla colonna</p>
                              </div>
                              <div class="tab-pane fade" id="aggiungi-comp-footer-testo" role="tabpanel" aria-labelledby="...">
                                    <div class="form-group">
                                        <label for="area-testo-xyz">Aggiungi un area testo</label>
                                        <textarea class="form-control" id="exampleFormControlTextarea2" rows="3"></textarea>
                                        <small class="text-muted">eventuale testo di supporto</small>
                                    </div>
                              </div>
                              <div class="tab-pane fade" id="aggiungi-comp-footer-menu" role="tabpanel" aria-labelledby="...">
                                    <div class="form-group">
                                        <label for="menu-footer-xyz">Aggiungi un menu</label>
                                        <select class="form-control" id="homepage-ita">
                                                <option>1</option>
                                                <option>2</option>
                                                <option>3</option>
                                                <option>4</option>
                                                <option>5</option>
                                        </select>
                                        <small class="text-muted">eventuale testo di supporto</small>
                                    </div>
                              </div>
                              <div class="tab-pane fade" id="aggiungi-comp-footer-social" role="tabpanel" aria-labelledby="...">
                                    <p>Mostra i link social attivati. Personalizza il compoente dal menu "Componenti > Social"</p>
                              </div>
                              <div class="tab-pane fade" id="aggiungi-comp-footer-lingue" role="tabpanel" aria-labelledby="...">
                                    <p>Mostra uno switch per le lingue attive. Personalizza il componente dal menu "Impostazioni > Impostazioni generali > Lingue"</p>
                              </div>
                            </div>


                      </div>
                      <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm"><i class="fas fa-check"></i> Salva</button>
                      </div>
                    </div>
              </div>
            </div>
          
            <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'elemento?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                                <div class="align-self-center">
                                    <span class="mr-3 align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                                    <div id="tipoElementoDaEliminare"></div>
                                </div>
                            </div>
                            <input type="text" class="d-none" id="elementoDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneElemento()"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
          
            <div class="modal fade" id="modifica-elemento" tabindex="-1" role="dialog" aria-labelledby="modifica impostazioni sezione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Modifica elemento</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form name="formModificaElemento" action="../controller/controllerPannelliLaterali.php" method="POST">
                                <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                <input type="text" class="d-none" id="idElementoDaModificare" name="idComponente">
                                <input type="text" class="d-none" id="elementoDaModificare" name="idElemento">
                                <input type="text" class="d-none" id="pannelloDaModificare" name="pannello">
                                
                                <div id="divIdElementoComponente" class="form-group row">
                                    <label for="ID-sezione" class="col-sm-2 col-form-label">Id elemento</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="elementoDaModificare" name="etichetta" onchange="aggiornaCampiEtichette()">
                                        <small class="form-text text-muted"> L'ID deve essere unico </small>
                                    </div>
                                </div>
                                
                                <div id="divTestoComponente" class="form-group row">
                                    <label for="classi-sezione" class="col-sm-2 col-form-label">Testo</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="testoDaModificare" name="testo">
                                        <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label for="classi-sezione" class="col-sm-2 col-form-label">Nome da mostrare</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="valoreElementoDaModificare" name="nomeDaMostrare">
                                        <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="document.formModificaElemento.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal fade" id="modalFileCaricato" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content bg-transparent">
                        <div class="modal-body m-0 p-0">
                            <div class="alert alert-success p-3 mb-0">
                                File caricato con con successo
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal fade" id="modalClonaConfigurazione" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Clona configurazione corrente</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Nuovo nome</label> 
                                <input type="text" id="nomeNuovaConfigurazione" name="nomeNuovaConfigurazione" placeholder="Nome della configurazione" class="form-control">
                            </div>

                            <div class="form-group">
                                <label class="extraspace-top">Note</label>
                                <textarea id="noteConfigurazione" name="noteConfigurazione" class="form-control"></textarea>
                                <p class="text-muted extraspace-top">Potrai caricare le combinazioni salvate in ogni momento. </p>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="clonaConfigurazione()"><i class="fas fa-check"></i> Clona</button>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="modal fade" id="modalModificaUtenzaApi" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Modifica utenza API</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <input type="text" id="idUtenzaDaModificare" class="d-none">
                            <div class="form-group">
                                <label>Nome utenza</label> 
                                <input type="text" id="modificaNomeUtenza" placeholder="Nome utenza" class="form-control">
                            </div>

                            <div class="form-group">
                                <label>CodiceSegreto</label>
                                <input type="text" id="modificaCodiceSegretoUtenza" placeholder="Codice segreto" class="form-control">
                            </div>
                            
                            <div class="row">
                                <div class="form-group col-md-3" id="contenitoreCheckboxAttivaUtenza">
                                     
                                </div>

                                <div class="form-group col-md-3" id="contenitoreCheckboxPermessiLetturaUtenza">
                                    
                                </div>

                                <div class="form-group col-md-3" id="contenitoreCheckboxPermessiScritturaUtenza">
                                    
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaUtenzaApi('../')"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="modal fade" id="popupEliminazioneComponentePannello" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare il componente dal pannello?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                                <div class="align-self-center text-center">
                                    <span class="align-self-center text-primary"><em id="nomeComponentePannelloDaEliminare"></em></span>
                                    <div id="tipoComponentePannelloDaEliminare"></div>
                                </div>
                            </div>
                            <input type="text" class="d-none" id="idComponentePannelloDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eliminaComponentePannello('../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="modal fade" id="popupEliminazioneUtenzaApi" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'utenza API?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <div class="align-self-center text-center">
                                    <span class="align-self-center text-primary"><em id="nomeUtenzaDaEliminare"></em></span>
                                </div>
                            </div>
                            <input type="text" class="d-none" id="idUtenzaDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneUtenzaApi('../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php 
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script><script>
            
            // form per il logo
            $("#frmLogo").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineLogo").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaLogo"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            
            // form per il logo mobile
            $("#frmLogoMobile").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineLogoMobile").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaLogoMobile"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            // form per il logo mobile
            $("#frmIconaApp").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineIconaApp").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaIconaApp"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            // form per la favicon
            $("#frmFavicon").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg,.ico",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineFavicon").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaFavicon"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })	    
            
            // form per il file stile.css
            $("#frmStileCss").dropzone({
                acceptedFiles: ".css",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    if(response=="ok") {
                        $("#modalFileCaricato").modal('show');
                    }
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaStileCss"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })	
            
            // form per il file stile.php
            $("#frmStilePhp").dropzone({
                acceptedFiles: ".php",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    if(response=="ok") {
                        $("#modalFileCaricato").modal('show');
                    }
                    else {
                        alert(response);
                    }
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaStilePhp"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>
        <script>
            
            function caricaConfigurazione(){
                var idConfigurazione = $('#idConfigurazione').val();

                $.ajax({
                    type:"POST",
                    url:"../controller/controllerImpostazioni.php",
                    data:{
                        operazione: "cambiaConfigurazioneAspetto",
                        id: idConfigurazione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            location.href = "impostazioni.php?status=300";
                        }
                        else {
                            alert(result);
                        }
                    },
                    error:function(){
                      alert("errore");
                    }
                });
            }
        
            function creaElemento(idCampoinput,pannello) {
                var idComponente = $('#'+idCampoinput).val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerPannelliLaterali.php",
                    data:{
                        operazione:"creaElemento",
                        idComponente:idComponente,
                        pannello:pannello
                    },
                    success:function(result) {
                        if(result=="ok") {
                            location.href = "impostazioni.php?status=230";
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function(xsr) {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function modificaElemento(id,idElemento,testo) {
                $('#idElementoDaModificare').val(id);
                $('#elementoDaModificare').val(idElemento);
                $('#testoDaModificare').val(testo);

         //     document.getElementById("divIdElementoComponente").className = 'd-none';
         //     document.getElementById("divTestoComponente").className = 'd-none';
                
                $('#modifica-elemento').modal('show');
            }
            
            function eliminaElemento(id,nomeComponente) {
                $('#elementoDaEliminare').val(id);
                document.getElementById("tipoElementoDaEliminare").innerHTML = nomeComponente;
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerPannelliLaterali.php",
                    data:{
                        operazione:"eliminaElemento",
                        idElemento:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("elementoPannello"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function clonaConfigurazione() {
                var nome                   = $('#nomeNuovaConfigurazione').val();
                var note                   = $('#noteConfigurazione').val();
                var sfondoBarraMenu        = $('#sfondoBarraMenu').val();
                var coloreTestoBarraMenu   = $('#coloreTestoBarraMenu').val();
                var linkFont               = $('#font-intestazioni').val()
                var fontIntestazioni       = $('#fontIntestazioni').val()
                var fontTesti              = $('#fontTesti').val()
                var colorePrimario         = $('#colorePrimario').val();
                var coloreSecondario       = $('#coloreSecondario').val();
                var coloreSuccess          = $('#coloreSuccess').val();
                var coloreLight            = $('#coloreLight').val();
                var coloreWarning          = $('#coloreWarning').val();
                var coloreDark             = $('#coloreDark').val();
                var coloreInfo             = $('#coloreInfo').val();
                var coloreDanger           = $('#coloreDanger').val();
                var colorePrimarioHover    = $('#colorePrimarioHover').val();
                var coloreSecondarioHover  = $('#coloreSecondarioHover').val();
                var coloreSuccessHover     = $('#coloreSuccessHover').val();
                var coloreLightHover       = $('#coloreLightHover').val();
                var coloreInfoHover        = $('#coloreInfoHover').val();
                var coloreWarningHover     = $('#coloreWarningHover').val();
                var coloreDarkHover        = $('#coloreDarkHover').val();
                var coloreDangerHover      = $('#coloreDangerHover').val();
                var colorePrimarioActive   = $('#colorePrimarioActive').val();
                var coloreSecondarioActive = $('#coloreSecondarioActive').val();
                var coloreSuccessActive    = $('#coloreSuccessActive').val();
                var coloreLightActive      = $('#coloreLightActive').val();
                var coloreInfoActive       = $('#coloreInfoActive').val();
                var coloreDarkActive       = $('#coloreDarkActive').val();
                var coloreWarningActive    = $('#coloreWarningActive').val();
                var coloreDangerActive     = $('#coloreDangerActive').val();
                var breakingPointsXs       = $('#breakingPointsXs').val();
                var breakingPointsMd       = $('#breakingPointsMd').val();
                var breakingPointsLg       = $('#breakingPointsLg').val();
                var breakingPointsXl       = $('#breakingPointsXl').val();
                var attivaColonnaSinistra  = "no";
                if(document.getElementById("attivaColonnaSinistra").checked==true) {
                    attivaColonnaSinistra = "si";
                }
                var colonnaSinistra        = $('#colonnaSinistra').val();
                var colonnaCentrale        = $('#colonnaCentrale').val();
                var attivaColonnaDestra     = "no";
                if(document.getElementById("attivaColonnaDestra").checked==true) {
                    attivaColonnaDestra = "si";
                }
                var colonnaDestra          = $('#colonnaDestra').val();
                var aspettoComponentiLaterali = $('#aspettoComponentiLaterali').val();
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerImpostazioni.php",
                    data:{
                        operazione             :"clonaConfigurazione",
                        nome                   :nome,
                        note                   :note,
                        sfondoBarraMenu        :sfondoBarraMenu,
                        coloreTestoBarraMenu   :coloreTestoBarraMenu,
                        linkFont               :linkFont,
                        fontIntestazioni       :fontIntestazioni,
                        fontTesti              :fontTesti,
                        colorePrimario         :colorePrimario,
                        coloreSecondario       :coloreSecondario,
                        coloreSuccess          :coloreSuccess,
                        coloreLight            :coloreLight,
                        coloreDark             :coloreDark,
                        coloreInfo             :coloreInfo,
                        coloreWarning          :coloreWarning,
                        coloreDanger           :coloreDanger,
                        colorePrimarioHover    :colorePrimarioHover,
                        coloreSecondarioHover  :coloreSecondarioHover,
                        coloreSuccessHover     :coloreSuccessHover,
                        coloreLightHover       :coloreLightHover,
                        coloreDarkHover        :coloreDarkHover,
                        coloreWarningHover     :coloreWarningHover,
                        coloreDangerHover      :coloreDangerHover,
                        coloreInfoHover        :coloreInfoActive,
                        colorePrimarioActive   :colorePrimarioActive,
                        coloreSecondarioActive :coloreSecondarioActive,
                        coloreSuccessActive    :coloreSuccessActive,
                        coloreLightActive      :coloreLightActive,
                        coloreDarkActive       :coloreDarkActive,
                        coloreInfoActive       :coloreInfoActive,
                        coloreWarningActive    :coloreWarningActive,
                        coloreDangerActive     :coloreDangerActive,
                        breakingPointsXs       :breakingPointsXs,
                        breakingPointsMd       :breakingPointsMd,
                        breakingPointsLg       :breakingPointsLg,
                        breakingPointsXl       :breakingPointsXl,
                        attivaColonnaSinistra  :attivaColonnaSinistra,
                        colonnaSinistra        :colonnaSinistra,
                        colonnaCentrale        :colonnaCentrale,
                        attivaColonnaDestra    :attivaColonnaDestra,
                        colonnaDestra          :colonnaDestra,
                        aspettoComponentiLaterali:aspettoComponentiLaterali
                    },
                    success:function(result) {
                        if(result=="ok") {
                            location.href = "impostazioni.php?status=311";
                        }
                        else {
                            alert(result);
                        }
                    },
                    error:function(){
                      alert("errore");
                    }
                });
            }
            
            function esportaConfigurazione() {
                var idConfigurazione = document.getElementById("idConfigurazione").value;
                location.href        = "../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geec_configurazioniAspetto&singoloId="+idConfigurazione;
            }
            
            function aggiornaLinguaPrincipale(lingua) {
                aggiornaCampoImpostazioni('geecB_impostazioniLingue',1,'linguaPrincipale',lingua);
                location.href='impostazioni.php?status=500';
            }
            
            function aggiornaDivUtenzeApi() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerApi.php",
                    data:{
                        operazione:"stampaUtenzeApi"
                    },
                    success:function(codice) {
                        document.getElementById("divElencoUtenzeApi").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function modificaUtenzaApi(id,nome,codiceSegreto,attiva,permessiLettura,permessiScrittura) {
                document.getElementById("idUtenzaDaModificare").value  = id;
                document.getElementById("modificaNomeUtenza").value    = nome;
                document.getElementById("modificaCodiceSegretoUtenza").value = codiceSegreto;


                if (typeof switchModificaApi !== 'undefined') { // se sono presenti gli switch vanno distrutti prima di ricrearli
                    switchModificaApi.destroy();
                }
                
                // creo lo switch per attiva api
                document.getElementById("contenitoreCheckboxAttivaUtenza").innerHTML = "";                    
                document.getElementById("contenitoreCheckboxAttivaUtenza").innerHTML = "<label class=\"d-block\">Attiva</label><input type=\"checkbox\" id=\"modificaAttivaApi\" value=\"si\" />";                    

                // creo lo switch per permessi lettura
                document.getElementById("contenitoreCheckboxPermessiLetturaUtenza").innerHTML = "";                    
                document.getElementById("contenitoreCheckboxPermessiLetturaUtenza").innerHTML = "<label class=\"d-block\">Permessi lettura</label><input type=\"checkbox\" id=\"modificaPermessiLettura\" value=\"si\" />";                    

                // creo lo switch per permessi scrittura
                document.getElementById("contenitoreCheckboxPermessiScritturaUtenza").innerHTML = "";                    
                document.getElementById("contenitoreCheckboxPermessiScritturaUtenza").innerHTML = "<label class=\"d-block\">Permessi scrittura</label><input type=\"checkbox\" id=\"modificaPermessiScrittura\" value=\"si\" />";                    
                
                
                var checkboxAttivaApi         = document.getElementById("modificaAttivaApi");
                var checkboxPermessiLettura   = document.getElementById("modificaPermessiLettura");
                var checkboxPermessiScrittura = document.getElementById("modificaPermessiScrittura");
                
                if(attiva==='si') {    
                    checkboxAttivaApi.checked = true;
                }
                if(permessiLettura=="si") {
                    checkboxPermessiLettura.checked = true;
                }
                if(permessiScrittura=="si") {
                    checkboxPermessiScrittura.checked = true;
                }
                
                var elementoSwitchModal = document.querySelector('#modificaAttivaApi');
                switchModificaApi  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });

                var elementoSwitchModal = document.querySelector('#modificaPermessiLettura');
                switchModificaPermessiLettura  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                var elementoSwitchModal = document.querySelector('#modificaPermessiScrittura');
                switchModificaPermessiScittura  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                $('#modalModificaUtenzaApi').modal('show');
            }
            
            function mostraDivClasseColonna(colonna) {
                var colonnaLetteraMaiuscola = colonna.charAt(0).toUpperCase() + colonna.slice(1);
                if(document.getElementById("attivaColonna"+colonnaLetteraMaiuscola).checked == true) {
                    document.getElementById("colonna"+colonnaLetteraMaiuscola).className = "form-control";
                }
                else {
                    document.getElementById("colonna"+colonnaLetteraMaiuscola).className = "d-none";
                }
            }
            
            function eseguiAggiornamentoMappeSito() {
                document.getElementById("iconaPulsanteAggiornamentoMappe").className = "fas fa-redo fa-spin";
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerImpostazioni.php",
                    data:{
                        operazione:"aggiornaMappeSito"
                    },
                    success:function(esito) {
                        document.getElementById("iconaPulsanteAggiornamentoMappe").className = "fas fa-redo";
                        if(esito=="ok") {
                            $('#labelOperazioneCompletata').text("Mappe aggiornate");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        </script>
    </body>
</html>